/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id: rX_Functions.h 4490 2020-08-13 13:32:21Z Robert $:

  Description:
    USER - Enumerations of RX-API- and Driver functions

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2020-08-11  Added jump table index for DPP2 functions
    2019-08-16  Fixed jump table index for Drv_IOGetLevel
    2013-01-15  Fixed "conflicting declaration" of RX_FUNCTIONS_E when using a C++ compiler
    2010-03-23  File created.

**************************************************************************************/

//#define _RX_FUNCTIONS_H
#ifndef _RX_FUNCTIONS_H
#define _RX_FUNCTIONS_H

#ifndef RX_JUMP_TABLE_BEGIN
  #define RX_JUMP_TABLE_BEGIN(name) enum name##_Etag {
#endif

#ifndef RX_JUMP_TABLE
  #define RX_JUMP_TABLE(ulIdx, jumpTableIndexName, functionName) jumpTableIndexName = ulIdx,
#endif

#ifndef RX_JUMP_TABLE_END
  #define RX_JUMP_TABLE_END(name,last) last}; typedef UINT16 name##_E;
#endif

#ifndef UNSUPPORTED_FUNCTION
  #define UNSUPPORTED_FUNCTION NULL
#endif

/* When modifying this table, please remember to update the sources of librcx_module.a! */

#ifndef EXCLUDE_RX_FUNCTIONS
RX_JUMP_TABLE_BEGIN(RX_FUNCTIONS)
RX_JUMP_TABLE(  0, RX_SYS_CREATE_TASK                        , rX_SysCreateTask                          )
RX_JUMP_TABLE(  1, RX_SYS_IDENTIFY_TASK                      , rX_SysIdentifyTask                        )
RX_JUMP_TABLE(  2, RX_SYS_DELETE_TASK                        , rX_SysDeleteTask                          )
RX_JUMP_TABLE(  3, RX_SYS_WAKEUP_TASK                        , rX_SysWakeupTask                          )
RX_JUMP_TABLE(  4, RX_SYS_RESUME_TASK                        , rX_SysResumeTask                          )
RX_JUMP_TABLE(  5, RX_SYS_BLOCK_TASK                         , rX_SysBlockTask                           )
RX_JUMP_TABLE(  6, RX_SYS_CHANGE_PRIORITY                    , rX_SysChangePriority                      )
RX_JUMP_TABLE(  7, RX_SYS_CREATE_HOOK_SYSTEMSTATUS           , rX_SysCreateHookSystemStatus              )
RX_JUMP_TABLE(  8, RX_SYS_SLEEP_TASK                         , rX_SysSleepTask                           )
RX_JUMP_TABLE(  9, RX_SYS_LOCK_SCHEDULER                     , rX_SysLockScheduler                       )
RX_JUMP_TABLE( 10, RX_SYS_UNLOCK_SCHEDULER                   , rX_SysUnlockScheduler                     )
RX_JUMP_TABLE( 11, RX_SYS_SHUTDOWN                           , rX_SysShutdown                            )
RX_JUMP_TABLE( 12, RX_SYS_GET_OWN_INSTANCE                   , rX_SysGetOwnInstance                      )
RX_JUMP_TABLE( 13, RX_SYS_GET_SYSTEM_TICKS                   , rX_SysGetSystemTicks                      )
RX_JUMP_TABLE( 14, RX_SYS_GET_SYSTEM_CYCLETIME               , rX_SysGetSystemCycletime                  )
RX_JUMP_TABLE( 15, RX_SYS_GET_CPU_CLOCKRATE                  , rX_SysGetCPUClockRate                     )
RX_JUMP_TABLE( 16, RX_SYS_SET_TASK_INITIALIZED               , rX_SysSetTaskInitialized                  )
RX_JUMP_TABLE( 17, RX_SYS_SET_SYSTEM_TICKS                   , rX_SysSetSystemTicks                      )
RX_JUMP_TABLE( 18, RX_SYS_TERMINATE_TASK                     , rX_SysTerminateTask                       )
RX_JUMP_TABLE( 19, RX_SYS_DELAY_TASK_UNTIL                   , rX_SysDelayTaskUntil                      )
RX_JUMP_TABLE( 20, RX_SYS_SPIN_LOCK                          , rX_SysSpinLock                            )
RX_JUMP_TABLE( 21, RX_SYS_SPIN_UNLOCK                        , rX_SysSpinUnlock                          )
RX_JUMP_TABLE( 22, RX_SYS_GET_TASK_HANDLE                    , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE( 23, RX_SYS_GET_OS_VERSION                     , rX_SysGetOSVersion                        )
RX_JUMP_TABLE( 24, RX_SYS_GET_FREE_PRIORITY                  , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE( 25, RX_BAR_CREATE_BARRIER                     , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE( 26, RX_BAR_DELETE_BARRIER                     , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE( 27, RX_BAR_IDENTIFY_BARRIER                   , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE( 28, RX_BAR_WAIT_AT_BARRIER                    , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE( 29, RX_CPR_PACK                               , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE( 30, RX_CPR_UNPACK                             , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE( 31, RX_CRC_CALCULATE_CRC                      , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE( 32, RX_CRC_CREATE_CRC_MACHINE                 , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE( 33, RX_CRC_DELETE_CRC_MACHINE                 , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE( 34, RX_EVE_WAIT_FOR_MULTIPLE                  , rX_EveWaitForMultiple                     )
RX_JUMP_TABLE( 35, RX_EVE_CREATE_EVENT_GROUP                 , rX_EveCreateEventGroup                    )
RX_JUMP_TABLE( 36, RX_EVE_SETUP_EVENT_GROUP                  , rX_EveSetupEventGroup                     )
RX_JUMP_TABLE( 37, RX_EVE_IDENTIFY_EVENT_GROUP               , rX_EveIdentifyEventGroup                  )
RX_JUMP_TABLE( 38, RX_EVE_CHANGE_EVENT_GROUP                 , rX_EveChangeEventGroup                    )
RX_JUMP_TABLE( 39, RX_EVE_WAIT_FOR_EVENT_GROUP               , rX_EveWaitForEventGroup                   )
RX_JUMP_TABLE( 40, RX_EVE_DELETE_EVENT_GROUP                 , rX_EveDeleteEventGroup                    )
RX_JUMP_TABLE( 41, RX_EVE_CREATE_MULTIPLE                    , rX_EveCreateMultiple                      )
RX_JUMP_TABLE( 42, RX_DEV_RESET                              , rX_DevReset                               )
RX_JUMP_TABLE( 43, RX_DEV_GET_STARTMODE                      , rX_DevGetStartmode                        )
RX_JUMP_TABLE( 44, RX_DIA_CREATE_INFORMATION_FIELD           , rX_DiaCreateInformationField              )
RX_JUMP_TABLE( 45, RX_DIA_GET_INFORMATION_FIELD              , rX_DiaGetInformationField                 )
RX_JUMP_TABLE( 46, RX_DIA_SET_TASK_STATUS                    , rX_DiaSetTaskStatus                       )
RX_JUMP_TABLE( 47, RX_DIA_GET_TASK_STATUS                    , rX_DiaGetTaskStatus                       )
RX_JUMP_TABLE( 48, RX_DIA_CREATE_HOOK_TASKSTATUS             , rX_DiaCreateHookTaskStatus                )
RX_JUMP_TABLE( 49, RX_FLT_CREATE_FAULTBUFFER                 , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE( 50, RX_FLT_FATAL_ERROR                        , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE( 51, RX_FLT_LOGG_FAULT                         , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE( 52, RX_FLT_GET_OLDEST_FAULT                   , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE( 53, RX_FLT_CREATE_HOOK_TRACE                  , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE( 54, RX_FLT_SET_TRACE_LEVEL                    , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE( 55, RX_FSM_ADD_TRANSITION                     , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE( 56, RX_FSM_IDENTIFY_STATE_MACHINE             , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE( 57, RX_FSM_SET_INITIAL_STATE                  , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE( 58, RX_FSM_IDENTIFY_STATE                     , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE( 59, RX_FSM_CREATE_STATE                       , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE( 60, RX_FSM_PROCESS                            , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE( 61, RX_FSM_CREATE_STATE_MACHINE               , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE( 62, RX_MBX_CREATE_MAILBOX                     , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE( 63, RX_MBX_DELETE_MAILBOX                     , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE( 64, RX_MBX_IDENTIFY_MAILBOX                   , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE( 65, RX_MBX_CLEAR_MAILBOX                      , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE( 66, RX_MBX_WAIT_FOR_MESSAGE                   , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE( 67, RX_MBX_DEMAND_SEGMENT                     , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE( 68, RX_MBX_RESTORE_MESSAGE                    , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE( 69, RX_MBX_GET_MESSAGE                        , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE( 70, RX_MBX_SEND_MESSAGE                       , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE( 71, RX_MBX_RETURN_MESSAGE                     , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE( 72, RX_MBX_RETURN_SEGMENT                     , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE( 73, RX_MBX_CREATE_MESSAGE_STORAGE             , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE( 74, RX_MBX_STORE_MESSSAGE                     , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE( 75, RX_MBX_GET_SEGMENT                        , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE( 76, RX_MBX_CREATE_HOOK_GET_SEGMENT            , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE( 77, RX_MBX_GET_REMAINING_SEGMENTS             , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE( 78, RX_MBX_GET_TASK_MAILBOX                   , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE( 79, RX_MBX_SEND_MESSAGE_RETURN                , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE( 80, RX_MBX_CREATE_MAILBOXBUFFER               , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE( 81, RX_MEM_CREATE_MEMORY_BANK                 , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE( 82, RX_MEM_ALLOCATE_MEMORY                    , rX_MemAllocateMemory                      )
RX_JUMP_TABLE( 83, RX_MEM_FREE_MEMORY                        , rX_MemFreeMemory                          )
RX_JUMP_TABLE( 84, RX_MEM_CREATE_SHARED_MEMORY               , rX_MemCreateSharedMemory                  )
RX_JUMP_TABLE( 85, RX_MEM_IDENTIFY_SHARED_MEMORY             , rX_MemIdentifySharedMemory                )
RX_JUMP_TABLE( 86, RX_MEM_GET_SHARED_MEMORY_INFO             , rX_MemGetSharedMemoryInfo                 )
RX_JUMP_TABLE( 87, RX_MEM_LOCK_SHARED_MEMORY                 , rX_MemLockSharedMemory                    )
RX_JUMP_TABLE( 88, RX_MEM_UNLOCK_SHARED_MEMORY               , rX_MemUnlockSharedMemory                  )
RX_JUMP_TABLE( 89, RX_MTX_CREATE_MUTEX                       , rX_MtxCreateMutex                         )
RX_JUMP_TABLE( 90, RX_MTX_IDENTIFY_MUTEX                     , rX_MtxIdentifyMutex                       )
RX_JUMP_TABLE( 91, RX_MTX_DELETE_MUTEX                       , rX_MtxDeleteMutex                         )
RX_JUMP_TABLE( 92, RX_MTX_LOCK_MUTEX                         , rX_MtxLockMutex                           )
RX_JUMP_TABLE( 93, RX_MTX_UNLOCK_MUTEX                       , rX_MtxUnlockMutex                         )
RX_JUMP_TABLE( 94, RX_QUE_CREATE_QUEUE                       , rX_QueCreateQueue                         )
RX_JUMP_TABLE( 95, RX_QUE_IDENTIFY_QUEUE                     , rX_QueIdentifyQueue                       )
RX_JUMP_TABLE( 96, RX_QUE_WAIT_FOR_PACKET                    , rX_QueWaitForPacket                       )
RX_JUMP_TABLE( 97, RX_QUE_SEND_PACKET                        , rX_QueSendPacket                          )
RX_JUMP_TABLE( 98, RX_QUE_SEND_PRIORITY_PACKET               , rX_QueSendPriorityPacket                  )
RX_JUMP_TABLE( 99, RX_QUE_POST_PACKET                        , rX_QuePostPacket                          )
RX_JUMP_TABLE(100, RX_QUE_PEEK_PACKET                        , rX_QuePeekPacket                          )
RX_JUMP_TABLE(101, RX_QUE_FLUSH_QUEUE                        , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(102, RX_QUE_DELETE_QUEUE                       , rX_QueDeleteQueue                         )
RX_JUMP_TABLE(103, RX_SEM_CREATE_SEMAPHORE                   , rX_SemCreateSemaphore                     )
RX_JUMP_TABLE(104, RX_SEM_IDENTIFY_SEMAPHORE                 , rX_SemIdentifySemaphore                   )
RX_JUMP_TABLE(105, RX_SEM_DELETE_SEMAPHORE                   , rX_SemDeleteSemaphore                     )
RX_JUMP_TABLE(106, RX_SEM_PUT_SEMAPHORE                      , rX_SemPutSemaphore                        )
RX_JUMP_TABLE(107, RX_SEM_WAIT_FOR_SEMAPHORE                 , rX_SemWaitForSemaphore                    )
RX_JUMP_TABLE(108, RX_SEM_GET_SEMAPHORE                      , rX_SemGetSemaphore                        )
RX_JUMP_TABLE(109, RX_SEM_WAIT_FOR_SEMAPHORE_COUNT           , rX_SemWaitForSemaphoreCount               )
RX_JUMP_TABLE(110, RX_SEM_CLEAR_SEMAPHORE_COUNT              , rX_SemClearSemaphoreCount                 )
RX_JUMP_TABLE(111, RX_SER_CREATE_SERIAL                      , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(112, RX_SER_IDENTIFY_SERIAL                    , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(113, RX_SER_DELETE_SERIAL                      , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(114, RX_SER_POST_SERIAL                        , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(115, RX_SER_PEND_SERIAL                        , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(116, RX_SER_CONFIRM_SERIAL                     , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(117, RX_SER_PUT_SERIAL_STREAM                  , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(118, RX_SER_GET_SERIAL_STREAM                  , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(119, RX_SIG_CREATE_SIGNAL                      , rX_SigCreateSignal                        )
RX_JUMP_TABLE(120, RX_SIG_IDENTIFY_SIGNAL                    , rX_SigIdentifySignal                      )
RX_JUMP_TABLE(121, RX_SIG_WAIT_FOR_SIGNAL                    , rX_SigWaitForSignal                       )
RX_JUMP_TABLE(122, RX_SIG_SET_SIGNAL                         , rX_SigSetSignal                           )
RX_JUMP_TABLE(123, RX_SIG_RESET_SIGNAL                       , rX_SigResetSignal                         )
RX_JUMP_TABLE(124, RX_TIM_CREATE_TIMER                       , rX_TimCreateTimer                         )
RX_JUMP_TABLE(125, RX_TIM_CREATE_CYCLE                       , rX_TimCreateCycle                         )
RX_JUMP_TABLE(126, RX_TIM_DELETE_CYCLE                       , rX_TimDeleteCycle                         )
RX_JUMP_TABLE(127, RX_TIM_WAIT_FOR_CYCLE                     , rX_TimWaitForCycle                        )
RX_JUMP_TABLE(128, RX_TIM_RESET_TIMER                        , rX_TimResetTimer                          )
RX_JUMP_TABLE(129, RX_TIM_STOP_TIMER                         , rX_TimStopTimer                           )
RX_JUMP_TABLE(130, RX_TIM_HALT_TIMER                         , rX_TimHaltTimer                           )
RX_JUMP_TABLE(131, RX_TIM_RESUME_TIMER                       , rX_TimResumeTimer                         )
RX_JUMP_TABLE(132, RX_TIM_DELETE_TIMER                       , rX_TimDeleteTimer                         )
RX_JUMP_TABLE(133, RX_TIM_GET_TIMER                          , rX_TimGetTime                             )
RX_JUMP_TABLE(134, RX_TIM_SET_TIMER                          , rX_TimSetTime                             )
RX_JUMP_TABLE(135, RX_TIM_SET_RELOAD                         , rX_TimSetReload                           )
RX_JUMP_TABLE(136, RX_TIM_RESET_CYCLE                        , rX_TimResetCycle                          )
RX_JUMP_TABLE(137, RX_VBS_PRINTF                             , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(138, RX_SYS_UNLOCK_IRQ                         , rX_SysUnlockIrq                           )
RX_JUMP_TABLE(139, RX_SYS_LOCK_IRQ                           , rX_SysLockIrq                             )
RX_JUMP_TABLE(140, DRV_INT_CREATE_INTERRUPT                  , Drv_IntCreateInterrupt                    )
RX_JUMP_TABLE(141, DRV_INT_IDENTIFY_INTERRUPT                , Drv_IntIdentifyInterrupt                  )
RX_JUMP_TABLE(142, DRV_INT_INITIALIZE_INTERRUPT              , Drv_IntInitializeInterrupt                )
RX_JUMP_TABLE(143, DRV_INT_DISABLE_INTERRUPT                 , Drv_IntDisableInterrupt                   )
RX_JUMP_TABLE(144, DRV_INT_ENABLE_INTERUPT                   , Drv_IntEnableInterrupt                    )
RX_JUMP_TABLE(145, DRV_INT_DELETE_INTERRUPT                  , Drv_IntDeleteInterrupt                    )
RX_JUMP_TABLE(146, DRV_INT_END_OF_INTERRUPT                  , Drv_IntEndOfInterrupt                     )
RX_JUMP_TABLE(147, DRV_INT_GENERATE_INTERRUPT                , Drv_IntGenerateInterrupt                  )
RX_JUMP_TABLE(148, DRV_INT_CONFIRM_INTERRUPT                 , Drv_IntConfirmInterrupt                   )
RX_JUMP_TABLE(149, DRV_INT_SET_COMMON_PRIORITY_LEVEL         , Drv_IntSetCommonPriorityLevel             )
RX_JUMP_TABLE(150, DRV_TIM_CREATE_TIMER                      , Drv_TimCreateTimer                        )
RX_JUMP_TABLE(151, DRV_TIM_IDENTIFY_TIMER                    , Drv_TimIdentifyTimer                      )
RX_JUMP_TABLE(152, DRV_TIM_INITIALIZE_TIMER                  , Drv_TimInitializeTimer                    )
RX_JUMP_TABLE(153, DRV_TIM_GET_TIME                          , Drv_TimGetTime                            )
RX_JUMP_TABLE(154, DRV_TIM_START_TIMER                       , Drv_TimStartTimer                         )
RX_JUMP_TABLE(155, DRV_TIM_STOP_TIMER                        , Drv_TimStopTimer                          )
RX_JUMP_TABLE(156, DRV_TIM_RELEASE_TIMER_INTERRUPT           , Drv_TimReleaseTimerInterrupt              )
RX_JUMP_TABLE(157, DRV_TIM_DELETE_TIMER                      , Drv_TimDeleteTimer                        )
RX_JUMP_TABLE(158, DRV_URT_CREATE_UART                       , Drv_UrtCreateUart                         )
RX_JUMP_TABLE(159, DRV_URT_INITIALIZE_UART                   , Drv_UrtInitializeUart                     )
RX_JUMP_TABLE(160, DRV_URT_IDENTIY_UART                      , Drv_UrtIdentifyUart                       )
RX_JUMP_TABLE(161, DRV_URT_ENABLE_UART                       , Drv_UrtEnableUart                         )
RX_JUMP_TABLE(162, DRV_URT_DISABLE_UART                      , Drv_UrtDisableUart                        )
RX_JUMP_TABLE(163, DRV_URT_SET_RECEIVE_MODE                  , Drv_UrtSetReceiveMode                     )
RX_JUMP_TABLE(164, DRV_URT_SEND_CHARACTER                    , Drv_UrtSendCharacter                      )
RX_JUMP_TABLE(165, DRV_URT_GET_CHARACTER                     , Drv_UrtGetCharacter                       )
RX_JUMP_TABLE(166, DRV_URT_RESET                             , Drv_UrtReset                              )
RX_JUMP_TABLE(167, DRV_URT_SET_TRANSMIT_MODE                 , Drv_UrtSetTransmitMode                    )
RX_JUMP_TABLE(168, DRV_URT_DELETE_UART                       , Drv_UrtDeleteUart                         )
RX_JUMP_TABLE(169, DRV_URT_CHANGE_RTS                        , Drv_UrtChangeRts                          )
RX_JUMP_TABLE(170, DRV_URT_GET_STATUS                        , Drv_UrtGetStatus                          )
RX_JUMP_TABLE(171, RX_MEM_CREATE_TRIPLE_BUFFER               , rX_MemCreateTripleBuffer                  )
RX_JUMP_TABLE(172, RX_MEM_IDENTIFY_TRIPLE_BUFFER             , rX_MemIdentifyTripleBuffer                )
RX_JUMP_TABLE(173, RX_MEM_EXCHANGE_BUFFER                    , rX_MemExchangeBuffer                      )
RX_JUMP_TABLE(174, RX_MEM_GET_EXCHANGED_BUFFER               , rX_MemGetExchangedBuffer                  )
RX_JUMP_TABLE(175, DRV_INT_UNINITIALIZE_INTERRUPT            , Drv_IntUninitializeInterrupt              )
RX_JUMP_TABLE(176, RX_DISPATCH                               , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(177, RX_SET_RDY                                , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(178, RX_CLEAR_RDY                              , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(179, RX_TASK_PREEMPTION                        , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(180, RX_TASK_PREEMPTION_TIME                   , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(181, RX_TASK_READY                             , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(182, RX_SIGNAL_DISPATCHER                      , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(183, RX_CONSTRUCT_OBJECT                       , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(184, RX_CHECK_OBJECT                           , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(185, RX_PARSE_OBJECT                           , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(186, RX_CHECK_TASK_STATE                       , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(187, RX_SET_LEAVE_FUNCTION                     , rX_SysCreateHookLeave                     )
RX_JUMP_TABLE(188, RX_QUE_GET_QUEUE_LOAD                     , rX_QueGetQueueLoad                        )
RX_JUMP_TABLE(189, DRV_EDD_CREATE_EDD                        , Drv_EddCreateEdd                          )
RX_JUMP_TABLE(190, DRV_EDD_IDENTIFY_EDD                      , Drv_EddIdentifyEdd                        )
RX_JUMP_TABLE(191, DRV_EDD_GET_FRAME_BUFFER                  , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(192, DRV_EDD_FREE_FRAME_BUFFER                 , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(193, DRV_EDD_SEND_FRAME                        , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(194, DRV_EDD_USER_REQUEST                      , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(195, RX_MEM_ALLOCATE_NAMED_MEMORY              , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(196, RX_INSTALL_FUNCTION_LIST                  , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(197, RX_SET_RESET                              , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(198, DRV_ICM_CREATE_ICM                        , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(199, DRV_ICM_IDENTIFY_ICM                      , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(200, DRV_ICM_INTERFACE                         , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(201, RX_FSM_DELETE_STATE_MACHINE               , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(202, RX_BAS_COPY_STRING                        , rX_BasCopyString                          )
RX_JUMP_TABLE(203, RX_BAS_GET_STRING_LENGTH                  , rX_BasGetStringLength                     )
RX_JUMP_TABLE(204, RX_BAS_COPY_MEMORY                        , rX_BasCopyMemory                          )
RX_JUMP_TABLE(205, RX_BAS_COPY_MEMORY_WORDS                  , rX_BasCopyMemoryWords                     )
RX_JUMP_TABLE(206, RX_BAS_COMPARE_MEMORY                     , rX_BasCompareMemory                       )
RX_JUMP_TABLE(207, RX_BAS_COMPARE_MEMORY_WORDS               , rX_BasCompareMemoryWords                  )
RX_JUMP_TABLE(208, RX_BAS_SET_MEMORY                         , rX_BasSetMemory                           )
RX_JUMP_TABLE(209, RX_BAS_SET_MEMORY_WORDS                   , rX_BasSetMemoryWords                      )
RX_JUMP_TABLE(210, DRV_CCH_INIT                              , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(211, DRV_CCH_CREATE_CACHE                      , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(212, DRV_CCH_INITIALIZE_CACHE                  , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(213, DRV_CCH_DRAIN_WRITE_BUFFER                , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(214, MID_DBM_OPEN_DBM_FILE                     , Mid_DbmOpenDbmFile                        )
RX_JUMP_TABLE(215, MID_DBM_IDENTIFY_TABLE                    , Mid_DbmIdentifyTable                      )
RX_JUMP_TABLE(216, MID_DBM_GET_DATASET_POINTER               , Mid_DbmGetDatasetPointer                  )
RX_JUMP_TABLE(217, MID_DBM_CLOSE_DBM_FILE                    , Mid_DbmCloseDbmFile                       )
RX_JUMP_TABLE(218, MID_FAT_INITIALIZE                        , Mid_FatInitialize                         )
RX_JUMP_TABLE(219, MID_FAT_DEINITIALIZE                      , Mid_FatDeinitialize                       )
RX_JUMP_TABLE(220, MID_FAT_FIND_FIRST                        , Mid_FatFindFirst                          )
RX_JUMP_TABLE(221, MID_FAT_FIND_NEXT                         , Mid_FatFindNext                           )
RX_JUMP_TABLE(222, MID_FAT_FIND_CLOSE                        , Mid_FatFindClose                          )
RX_JUMP_TABLE(223, MID_FAT_FORMAT                            , Mid_FatFormat                             )
RX_JUMP_TABLE(224, MID_FAT_FLUSH                             , Mid_FatFlush                              )
RX_JUMP_TABLE(225, MID_FAT_CREATE_FILE                       , Mid_FatCreateFile                         )
RX_JUMP_TABLE(226, MID_FAT_PUT_FILE_CHAR                     , Mid_FatPutFileChar                        )
RX_JUMP_TABLE(227, MID_FAT_WRITE_FILE                        , Mid_FatWriteFile                          )
RX_JUMP_TABLE(228, MID_FAT_GET_FILE_CHAR                     , Mid_FatGetFileChar                        )
RX_JUMP_TABLE(229, MID_FAT_READ_FILE                         , Mid_FatReadFile                           )
RX_JUMP_TABLE(230, MID_FAT_OPEN_FILE                         , Mid_FatOpenFile                           )
RX_JUMP_TABLE(231, MID_FAT_CLOSE_FILE                        , Mid_FatCloseFile                          )
RX_JUMP_TABLE(232, MID_FAT_GET_FILE_SIZE                     , Mid_FatGetFileSize                        )
RX_JUMP_TABLE(233, MID_FAT_TELL_FILE_POSITION                , Mid_FatTellFilePosition                   )
RX_JUMP_TABLE(234, MID_FAT_SEEK_FILE                         , Mid_FatSeekFile                           )
RX_JUMP_TABLE(235, MID_FAT_MAKE_DIRECTORY                    , Mid_FatMakeDirectory                      )
RX_JUMP_TABLE(236, MID_FAT_CHANGE_DIRECTORY                  , Mid_FatChangeDirectory                    )
RX_JUMP_TABLE(237, MID_FAT_DELETE                            , Mid_FatDelete                             )
RX_JUMP_TABLE(238, MID_FAT_RENAME                            , Mid_FatRename                             )
RX_JUMP_TABLE(239, MID_FAT_DELETE_ALL                        , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(240, MID_FAT_NORMALIZE_FILENAME                , Mid_FatNormalizeFilename                  )
RX_JUMP_TABLE(241, DRV_HST_CREATE_HOST                       , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(242, DRV_LED_CREATE_LED                        , Drv_LedCreateLed                          )
RX_JUMP_TABLE(243, DRV_LED_IDENTIFY_LED                      , Drv_LedIdentifyLed                        )
RX_JUMP_TABLE(244, DRV_LED_SET_LED                           , Drv_LedSetLed                             )
RX_JUMP_TABLE(245, DRV_LED_CLEAR_LED                         , Drv_LedClearLed                           )
RX_JUMP_TABLE(246, DRV_LED_INVERT_LED                        , Drv_LedInvertLed                          )
RX_JUMP_TABLE(247, DRV_LED_INITIALIZE_LED                    , Drv_LedInitializeLed                      )
RX_JUMP_TABLE(248, DRV_MMU_INIT                              , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(249, DRV_MMU_CREATE_MMU                        , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(250, DRV_MMU_INITIALIZE_MMU                    , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(251, RX_MEM_REQUEST_PHYS_REGION                , rX_MemRequestPhysRegion                   )
RX_JUMP_TABLE(252, RX_MEM_RELEASE_PHYS_REGION                , rX_MemReleasePhysRegion                   )
RX_JUMP_TABLE(253, DRV_MPU_CREATE_MPU                        , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(254, DRV_MPU_INITIALIZE_MPU                    , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(255, DRV_MPU_ENABLE_MPU                        , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(256, DRV_PFL_CREATE_FLASH                      , Drv_PflCreateFlash                        )
RX_JUMP_TABLE(257, DRV_PFL_IDENTIFY_FLASH                    , Drv_PflIdentifyFlash                      )
RX_JUMP_TABLE(258, DRV_PFL_ERASE_FLASH_SECTOR                , Drv_PflEraseFlashSector                   )
RX_JUMP_TABLE(259, DRV_PFL_ERASE_FLASH                       , Drv_PflEraseFlash                         )
RX_JUMP_TABLE(260, DRV_PFL_ERASE_FLASH_DEVICE                , Drv_PflEraseFlashDevice                   )
RX_JUMP_TABLE(261, DRV_PFL_GET_NUM_FLASH_SECTORS             , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(262, DRV_PFL_GET_FLASH_SECTOR_SIZE             , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(263, DRV_PFL_GET_FLASH_INFO                    , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(264, DRV_PFL_WRITE_FLASH                       , Drv_PflWriteFlash                         )
RX_JUMP_TABLE(265, DRV_PFL_READ_FLASH                        , Drv_PflReadFlash                          )
RX_JUMP_TABLE(266, DRV_PHY_CREATE_PHY                        , Drv_PhyCreatePhy                          )
RX_JUMP_TABLE(267, DRV_PHY_IDENTIFY_PHY                      , Drv_PhyIdentifyPhy                        )
RX_JUMP_TABLE(268, DRV_PHY_TEST_LOOPBACK                     , Drv_PhyTestLoopback                       )
RX_JUMP_TABLE(269, DRV_PHY_INITIALIZE                        , Drv_PhyInitialize                         )
RX_JUMP_TABLE(270, DRV_PHY_READ_REGISTER                     , Drv_PhyReadRegister                       )
RX_JUMP_TABLE(271, DRV_PHY_WRITE_REGISTER                    , Drv_PhyWriteRegister                      )
RX_JUMP_TABLE(272, DRV_RDK_FORMAT_RAMDISK                    , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(273, DRV_RDK_INITIALIZE_RAMDISK                , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(274, DRV_RDK_DEINITIALIZE_RAMDISK              , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(275, DRV_RDK_READ_RAMDISK_SECTOR               , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(276, DRV_RDK_WRITE_RAMDISK_SECTOR              , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(277, RX_STA_GET_CPU_LOAD                       , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(278, DRV_TCM_CREATE_TCM                        , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(279, DRV_TCM_INITIALIZE_TCM                    , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(280, MID_TSS_ADD_TASK_TIME_SLICE               , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(281, MID_TSS_START_TIME_SLICING                , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(282, MID_TSS_REMOVE_TASK_TIME_SLICE            , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(283, MID_TSS_RELINQUISH_TASK                   , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(284, DRV_VOL_CREATE_VOLUME                     , Drv_VolCreateVolume                       )
RX_JUMP_TABLE(285, DRV_VOL_DELETE_VOLUME                     , Drv_VolDeleteVolume                       )
RX_JUMP_TABLE(286, DRV_VOL_IDENTIFY_VOLUME                   , Drv_VolIdentifyVolume                     )
RX_JUMP_TABLE(287, DRV_VOL_MOUNT_VOLUME                      , Drv_VolMountVolume                        )
RX_JUMP_TABLE(288, DRV_VOL_UNMOUNT_VOLUME                    , Drv_VolUnmountVolume                      )
RX_JUMP_TABLE(289, DRV_VOL_LOCK_VOLUME                       , Drv_VolLockVolume                         )
RX_JUMP_TABLE(290, DRV_VOL_UNLOCK_VOLUME                     , Drv_VolUnlockVolume                       )
RX_JUMP_TABLE(291, DRV_XC_CREATE_XC                          , Drv_XcCreateXc                            )
RX_JUMP_TABLE(292, DRV_XC_IDENTIFY_XC                        , Drv_XcIdentifyXc                          )
RX_JUMP_TABLE(293, DRV_XC_LOAD_XC_PROGRAM                    , Drv_XcLoadXcProgram                       )
RX_JUMP_TABLE(294, DRV_XC_VERIFY_XC_PROGRAM                  , Drv_XcVerifyXcProgram                     )
RX_JUMP_TABLE(295, DRV_XC_ENABLE_XC                          , Drv_XcEnableXc                            )
RX_JUMP_TABLE(296, DRV_XC_DISABLE_XC                         , Drv_XcDisableXc                           )
RX_JUMP_TABLE(297, DRV_XC_GET_ADDRESS                        , Drv_XcGetAddress                          )
RX_JUMP_TABLE(298, DRV_XC_LINK_COMMUNICATION_BLOCK           , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(299, DRV_XC_UNLINK_COMMUNICATION_BLOCK         , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(300, DRV_XC_WRITE_XC                           , Drv_XcWriteXc                             )
RX_JUMP_TABLE(301, DRV_XC_READ_XC                            , Drv_XcReadXc                              )
RX_JUMP_TABLE(302, DRV_XC_CHECK_SENTINEL                     , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(303, DRV_XC_GET_XC_ADDRESS                     , Drv_XcGetXcAddress                        )
RX_JUMP_TABLE(304, DRV_XC_CLAIM_ACCESS                       , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(305, DRV_XC_RELEASE_ACCESS                     , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(306, DRV_XC_GET_INTERRUPT                      , Drv_XcGetInterrupt                        )
RX_JUMP_TABLE(307, DRV_XC_SET_INTERRUPT                      , Drv_XcSetInterrupt                        )
RX_JUMP_TABLE(308, DRV_EXPT_SET_EXCEPTION_HANDLER            , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(309, DRV_EXPT_RESET_EXCEPTION_HANDLER          , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(310, RX_MEM_DELETE_TRIPLE_BUFFER               , rX_MemDeleteTripleBuffer                  )
RX_JUMP_TABLE(311, RX_MEM_REALLOCATE_MEMORY                  , rX_MemReAllocateMemory                    )
RX_JUMP_TABLE(312, DRV_EDD_UNREGISTER_APP                    , Drv_EddUnregisterApp                      )
RX_JUMP_TABLE(313, DRV_EDD_REGISTER_APP                      , Drv_EddRegisterApp                        )
RX_JUMP_TABLE(314, DRV_EDD_GET_FRAME                         , Drv_EddGetFrame                           )
RX_JUMP_TABLE(315, DRV_EDD_FREE_FRAME                        , Drv_EddFreeFrame                          )
RX_JUMP_TABLE(316, DRV_EDD_SEND_CBK                          , Drv_EddSendCbk                            )
RX_JUMP_TABLE(317, DRV_EDD_IOCTL                             , Drv_EddIoctl                              )
RX_JUMP_TABLE(318, DRV_EDD_REGISTER_CBK                      , Drv_EddRegisterCbk                        )
RX_JUMP_TABLE(319, DRV_EDD_UNREGISTER_CBK                    , Drv_EddUnregisterCbk                      )
RX_JUMP_TABLE(320, DRV_EDD_GET_ERROR_CODE                    , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(321, DRV_EDD_SET_FLOW_CBK                      , Drv_EddSetFlowCbk                         )
RX_JUMP_TABLE(322, DRV_EDD_CLR_FLOW_CBK                      , Drv_EddClearFlowCbk                       )
RX_JUMP_TABLE(323, DRV_EDD_SEND_NO_FLW_CTL                   , Drv_EddSendNoFlowCtl                      )
RX_JUMP_TABLE(324, DRV_EDD_SET_PROMISC_CBK                   , Drv_EddSetPromiscCbk                      )
RX_JUMP_TABLE(325, DRV_EDD_CLR_PROMISC_CBK                   , Drv_EddClearPromisc                       )
RX_JUMP_TABLE(326, DRV_EDD_REGISTER_LINK_STATUS              , Drv_EddRegisterLinkStatus                 )
RX_JUMP_TABLE(327, DRV_EDD_UNREGISTER_LINK_STATUS            , Drv_EddUnregisterLinkStatus               )
RX_JUMP_TABLE(328, DRV_EDD_REGISTER_APP_ETH                  , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(329, DRV_EBUS_CREATE_EBUS                      , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(330, DRV_EBUS_IDENTIFY_EBUS                    , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(331, DRV_EBUS_INITIALIZE_EBUS                  , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(332, DRV_FIF_CREATE_FIFO_CHANNEL               , Drv_FifCreateFifochannel                  )
RX_JUMP_TABLE(333, DRV_FIF_IDENTIFY_FIFO_CHANNEL             , Drv_FifIdentifyFifochannel                )
RX_JUMP_TABLE(334, DRV_FIF_WRITE_TO_FIFO                     , Drv_FifWriteToFifo                        )
RX_JUMP_TABLE(335, DRV_FIF_READ_TO_FIFO                      , Drv_FifReadFromFifo                       )
RX_JUMP_TABLE(336, DRV_FIF_SET_FIFO_RESET                    , Drv_FifSetFifoReset                       )
RX_JUMP_TABLE(337, DRV_FIF_CLEAR_FIFO_RESET                  , Drv_FifClearFifoReset                     )
RX_JUMP_TABLE(338, DRV_FIF_IS_FIFO_UNDERRUN                  , Drv_FifIsFifoUnderrun                     )
RX_JUMP_TABLE(339, DRV_FIF_IS_FIFO_OVERFLOW                  , Drv_FifIsFifoOverflow                     )
RX_JUMP_TABLE(340, DRV_FIF_IS_FIFO_EMPTY                     , Drv_FifIsFifoEmpty                        )
RX_JUMP_TABLE(341, DRV_FIF_IS_FIFO_FULL                      , Drv_FifIsFifoFull                         )
RX_JUMP_TABLE(342, DRV_FIF_GET_FIFO_FILL_LEVEL               , Drv_FifGetFifoFillLevel                   )
RX_JUMP_TABLE(343, DRV_GPIO_CREATE_GPIO                      , Drv_GpioCreateGpio                        )
RX_JUMP_TABLE(344, DRV_GPIO_IDENTIFY_GPIO                    , Drv_GpioIdentifyGpio                      )
RX_JUMP_TABLE(345, DRV_GPIO_INITIALIZE_GPIO                  , Drv_GpioInitializeGpio                    )
RX_JUMP_TABLE(346, DRV_GPIO_SET_OUTPUT                       , Drv_GpioSetOutput                         )
RX_JUMP_TABLE(347, DRV_GPIO_CLEAR_OUTPUT                     , Drv_GpioClearOutput                       )
RX_JUMP_TABLE(348, DRV_GPIO_GET_INPUT                        , Drv_GpioGetInput                          )
RX_JUMP_TABLE(349, DRV_HIF_CREATE_HIF                        , Drv_HifCreateHif                          )
RX_JUMP_TABLE(350, DRV_HIF_IDENTIFY_HIF                      , Drv_HifIdentifyHif                        )
RX_JUMP_TABLE(351, DRV_HIF_INITIALIZE_HIF                    , Drv_HifInitializeHif                      )
RX_JUMP_TABLE(352, DRV_HIF_GET_INPUTS                        , Drv_HifGetInputs                          )
RX_JUMP_TABLE(353, DRV_HIF_SET_OUTPUTS                       , Drv_HifSetOutputs                         )
RX_JUMP_TABLE(354, DRV_HIF_GET_OUTPUTS                       , Drv_HifGetOutputs                         )
RX_JUMP_TABLE(355, DRV_RSRVD1                                , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(356, DRV_RSRVD2                                , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(357, DRV_RSRVD3                                , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(358, DRV_RSRVD4                                , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(359, DRV_RSRVD5                                , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(360, DRV_RSRVD6                                , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(361, DRV_RSRVD7                                , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(362, DRV_RSRVD8                                , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(363, DRV_SPI_CREATE_SPI                        , Drv_SpiCreateSpi                          )
RX_JUMP_TABLE(364, DRV_SPI_IDENTIFY_SPI                      , Drv_SpiIdentifySpi                        )
RX_JUMP_TABLE(365, DRV_SPI_INITIALIZE_SPI                    , Drv_SpiInitializeSpi                      )
RX_JUMP_TABLE(366, DRV_SPI_CONFIGURE                         , Drv_SpiConfigure                          )
RX_JUMP_TABLE(367, DRV_SPI_OPEN                              , Drv_SpiOpen                               )
RX_JUMP_TABLE(368, DRV_SPI_SLAVE_SELECT                      , Drv_SpiSlaveSelect                        )
RX_JUMP_TABLE(369, DRV_SPI_SLAVE_DESELECT                    , Drv_SpiSlaveDeselect                      )
RX_JUMP_TABLE(370, DRV_SPI_SEND_RECEIVE                      , Drv_SpiSendReceive                        )
RX_JUMP_TABLE(371, DRV_SPI_SEND                              , Drv_SpiSend                               )
RX_JUMP_TABLE(372, DRV_SPI_RECEIVE                           , Drv_SpiReceive                            )
RX_JUMP_TABLE(373, DRV_SPI_SEND_IDLE                         , Drv_SpiSendIdle                           )
RX_JUMP_TABLE(374, DRV_SPI_CLOSE                             , Drv_SpiClose                              )
RX_JUMP_TABLE(375, DRV_SPI_DELETE_SPI                        , Drv_SpiDeleteSpi                          )
RX_JUMP_TABLE(376, DRV_PIO_CREATE_PIO                        , Drv_PioCreatePio                          )
RX_JUMP_TABLE(377, DRV_PIO_IDENTIFY_PIO                      , Drv_PioIdentifyPio                        )
RX_JUMP_TABLE(378, DRV_PIO_INITIALIZE_PIO                    , Drv_PioInitializePio                      )
RX_JUMP_TABLE(379, DRV_PIO_SET_OUTPUTS                       , Drv_PioSetOutputs                         )
RX_JUMP_TABLE(380, DRV_PIO_CLEAR_OUTPUTS                     , Drv_PioClearOutputs                       )
RX_JUMP_TABLE(381, DRV_PIO_GET_INPUTS                        , Drv_PioGetInputs                          )
RX_JUMP_TABLE(382, DRV_SFL_CREATE_FLASH                      , Drv_SflCreateFlash                        )
RX_JUMP_TABLE(383, DRV_SFL_IDENTIFY_FLASH                    , Drv_SflIdentifyFlash                      )
RX_JUMP_TABLE(384, DRV_SFL_INITIALIZE_FLASH                  , Drv_SflInitializeFlash                    )
RX_JUMP_TABLE(385, DRV_SFL_ERASE_PAGE                        , Drv_SflEraseFlashPage                     )
RX_JUMP_TABLE(386, DRV_SFL_ERASE_FLASH                       , Drv_SflEraseFlash                         )
RX_JUMP_TABLE(387, DRV_SFL_ERASE_FLASHDEVICE                 , Drv_SflEraseFlashDevice                   )
RX_JUMP_TABLE(388, DRV_SFL_WRITE_FLASH                       , Drv_SflWriteFlash                         )
RX_JUMP_TABLE(389, DRV_SFL_READ_FLASH                        , Drv_SflReadFlash                          )
RX_JUMP_TABLE(390, DRV_CCH_CLEAN_CACHE                       , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(391, DRV_EDD_GET_BUFFER                        , Drv_EddGetBuffer                          )
RX_JUMP_TABLE(392, DRV_EDD_FREE_BUFFER                       , Drv_EddFreeBuffer                         )
RX_JUMP_TABLE(393, DRV_EDD_REGISTER_ETH_CB                   , Drv_EddRegisterEthCb                      )
RX_JUMP_TABLE(394, DRV_EDD_REGISTER_UDP_CB                   , Drv_EddRegisterUdpCb                      )
RX_JUMP_TABLE(395, DRV_EDD_SET_PROMISC_CB                    , Drv_EddSetPromiscCb                       )
RX_JUMP_TABLE(396, DRV_EDD_SEND_BUFFER                       , Drv_EddSendBuffer                         )
RX_JUMP_TABLE(397, DRV_HIF_IDENTIFY_CHANNEL                  , Drv_HifIdentifyChannel                    )
RX_JUMP_TABLE(398, DRV_HIF_ENABLE_CHANNEL                    , Drv_HifEnableChannel                      )
RX_JUMP_TABLE(399, DRV_HIF_CHANGE_HANDSHK_BIT                , Drv_HifChangeHandshkBit                   )
RX_JUMP_TABLE(400, DRV_HIF_ACCESS_BLOCK_DONE                 , Drv_HifAccessBlockDone                    )
RX_JUMP_TABLE(401, DRV_HIF_IDENTIFY_BLOCK                    , Drv_HifIdentifyBlock                      )
RX_JUMP_TABLE(402, DRV_HIF_CREATE_BLOCK                      , Drv_HifCreateBlock                        )
RX_JUMP_TABLE(403, DRV_HIF_ENABLE_BLOCK                      , Drv_HifEnableBlock                        )
RX_JUMP_TABLE(404, DRV_HIF_READ_FROM_BLOCK                   , Drv_HifReadFromBlock                      )
RX_JUMP_TABLE(405, DRV_HIF_WRITE_TO_BLOCK                    , Drv_HifWriteToBlock                       )
RX_JUMP_TABLE(406, DRV_HIF_WAIT_FOR_BLOCK_CONFIRMED          , Drv_HifWaitForBlockConfirmed              )
RX_JUMP_TABLE(407, DRV_HIF_GET_BLOCK_INFORMATION             , Drv_HifGetBlockInformation                )
RX_JUMP_TABLE(408, DRV_HIF_CREATE_CHANNEL                    , Drv_HifCreateChannel                      )
RX_JUMP_TABLE(409, DRV_HIF_OFFSET_READ_FROM_BLOCK            , Drv_HifOffsetReadFromBlock                )
RX_JUMP_TABLE(410, DRV_HIF_OFFSET_WRITE_TO_BLOCK             , Drv_HifOffsetWriteToBlock                 )
RX_JUMP_TABLE(411, DRV_HIF_GET_BLOCK_BASE_POINTER            , Drv_HifGetBlockBasePointer                )
RX_JUMP_TABLE(412, DRV_SEC_GET_DEVICE_INFO                   , Drv_SecGetDeviceInfo                      )
RX_JUMP_TABLE(413, DRV_SEC_GET_MAC_ADDRESS                   , Drv_SecGetMacAddress                      )
RX_JUMP_TABLE(414, DRV_SEC_SET_MAC_ADDRESS                   , Drv_SecSetMacAddress                      )
RX_JUMP_TABLE(415, DRV_SEC_GET_RAW_AREA                      , Drv_SecGetRawArea                         )
RX_JUMP_TABLE(416, DRV_SEC_SET_RAW_AREA                      , Drv_SecSetRawArea                         )
RX_JUMP_TABLE(417, DRV_SEC_FLUSH                             , Drv_SecFlush                              )
RX_JUMP_TABLE(418, RX_GET_FREE_DRIVER_TOKEN                  , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(419, RX_SYS_REMOVE_TASK_FROM_INITIALIZATION    , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(420, MID_SYS_DRIVER_CFG_INIT                   , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(421, DRV_HIF_SET_COM_LED_STATE                 , Drv_HifSetComLedState                     )
RX_JUMP_TABLE(422, DRV_HIF_SET_APP_LED_STATE                 , Drv_HifSetAppLedState                     )
RX_JUMP_TABLE(423, DRV_HIF_SET_SYSTEM_STATUS_LED_STATE       , Drv_HifSetSystemStatusLedState            )
RX_JUMP_TABLE(424, DRV_FIQ_CREATE_INTERRUPT                  , Drv_FiqCreateInterrupt                    )
RX_JUMP_TABLE(425, DRV_FIQ_IDENTIFY_INTERRUPT                , Drv_FiqIdentifyInterrupt                  )
RX_JUMP_TABLE(426, DRV_FIQ_INITIALIZE_INTERRUPT              , Drv_FiqInitializeInterrupt                )
RX_JUMP_TABLE(427, DRV_FIQ_ENABLE_INTERRUPT                  , Drv_FiqEnableInterrupt                    )
RX_JUMP_TABLE(428, DRV_FIQ_DISABLE_INTERRUPT                 , Drv_FiqDisableInterrupt                   )
RX_JUMP_TABLE(429, RX_GET_JUMP_TABLE_BASE                    , rX_GetJumpTableBase                       )
RX_JUMP_TABLE(430, DRV_HIF_ACCESS_BLOCK_LOCKED               , Drv_HifAccessBlockLocked                  )
RX_JUMP_TABLE(431, DRV_HIF_CHANGE_HNDSHK_MODE                , Drv_HifChangeHndshkMode                   )
RX_JUMP_TABLE(432, DRV_HIF_DISABLE_BLOCK                     , Drv_HifDisableBlock                       )
RX_JUMP_TABLE(433, DRV_HIF_ENABLE_BITFUNCTION                , Drv_HifEnableBitFunction                  )
RX_JUMP_TABLE(434, DRV_VOL_GET_ENTRY                         , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(435, RX_DEV_GET_BOOT_TYPE                      , rX_DevGetBoottype                         )
RX_JUMP_TABLE(436, DRV_HIF_GET_HANDSHK_BIT                   , Drv_HifGetHandshkBit                      )
RX_JUMP_TABLE(437, DRV_GPIO_SETUP_LED_OPERATIONS             , Drv_GpioSetupLedOperations                )
RX_JUMP_TABLE(439, DRV_PIO_SETUP_LED_OPERATIONS              , Drv_PioSetupLedOperations                 )
#if defined(__NETX50) || defined(__NETX100) || defined(__NETX500) /* HifPio Driver only available on netX50/100/500 */
RX_JUMP_TABLE(438, DRV_HIFPIO_SETUP_LED_OPERATIONS           , Drv_HifPioSetupLedOperations              )
RX_JUMP_TABLE(440, DRV_HIFPIO_CREATE_HIFPIO                  , Drv_HifPioCreateHifPio                    )
RX_JUMP_TABLE(441, DRV_HIFPIO_IDENTIFY_HIFPIO                , Drv_HifPioIdentifyHifPio                  )
RX_JUMP_TABLE(442, DRV_HIFPIO_INITIALIZE_HIFPIO              , Drv_HifPioInitializeHifPio                )
RX_JUMP_TABLE(443, DRV_HIFPIO_GET_INPUTS                     , Drv_HifPioGetInputs                       )
RX_JUMP_TABLE(444, DRV_HIFPIO_SET_OUTPUTS                    , Drv_HifPioSetOutputs                      )
RX_JUMP_TABLE(445, DRV_HIFPIO_GET_OUTPUTS                    , Drv_HifPioGetOutputs                      )
#else
RX_JUMP_TABLE(438, DRV_HIFPIO_SETUP_LED_OPERATIONS           , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(440, DRV_HIFPIO_CREATE_HIFPIO                  , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(441, DRV_HIFPIO_IDENTIFY_HIFPIO                , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(442, DRV_HIFPIO_INITIALIZE_HIFPIO              , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(443, DRV_HIFPIO_GET_INPUTS                     , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(444, DRV_HIFPIO_SET_OUTPUTS                    , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(445, DRV_HIFPIO_GET_OUTPUTS                    , UNSUPPORTED_FUNCTION                      )
#endif
RX_JUMP_TABLE(446, MID_DBM_LL_GET_FIRST_REC                  , Mid_DbmLLGetFirstRecordPtr                )
RX_JUMP_TABLE(447, MID_DBM_LL_GET_NEXT_REC                   , Mid_DbmLLGetNextRecordPtr                 )
RX_JUMP_TABLE(448, MID_DBM_GET_TAB_PROP                      , Mid_DbmGetTabProperty                     )
RX_JUMP_TABLE(449, MID_DBM_GET_REC_PROP                      , Mid_DbmGetRecProperty                     )
RX_JUMP_TABLE(450, MID_DBM_GET_FIRST_KEY                     , Mid_DbmLLGetFirstKEY                      )
RX_JUMP_TABLE(451, MID_DBM_GET_NEXT_KEY                      , Mid_DbmLLGetNextKEY                       )
RX_JUMP_TABLE(452, MID_DBM_CALC_CHECKSUM                     , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(453, RX_CHANGE_READY_STATUS                    , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(454, RX_CHANGE_RUNNING_STATUS                  , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(455, RX_DELETE_OBJECT                          , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(456, RX_UNLINK_OBJECT                          , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(457, RX_REMOVE_HOOK                            , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(458, RX_GET_HOOK                               , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(459, RX_CREATE_HOOK                            , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(460, RX_SYS_INTERLOCK_EXCHANGE                 , rX_SysInterlockExchange                   )
RX_JUMP_TABLE(461, RX_CPU_EXPT_SET_SYSTEM_VECTOR             , rX_CpuSetExceptionVector                  )
RX_JUMP_TABLE(462, RX_CPU_EXPT_SET_USER_VECTOR               , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(463, RX_CPU_EXPT_GET_SYSTEM_VECTOR             , rX_CpuGetExceptionVector                  )
RX_JUMP_TABLE(464, RX_CPU_EXPT_GET_USER_VECTOR               , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(465, RX_SCHED_SET_FATAL_VECTOR                 , rX_SchedSetFatalVector                    )
RX_JUMP_TABLE(466, RX_SCHED_GET_FATAL_VECTOR                 , rX_SchedGetFatalVector                    )
RX_JUMP_TABLE(467, RX_SYS_GET_FATAL_CONDITION                , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(468, RX_CONSTRUCT_OBJECT_FASTLOCK              , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(469, RX_PARSE_OBJECT_FASTLOCK                  , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(470, RX_UNLINK_OBJECT_FASTLOCK                 , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(471, RX_SYS_GET_OWN_TASK_HANDLE                , rX_SysGetOwnTaskHandle                    )
RX_JUMP_TABLE(472, RX_SYS_CREATE_IRQ_TASK                    , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(473, RX_WAIT_SINGLE_OBJECT                     , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(474, RX_WAIT_RESUME_TASK                       , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(475, RX_WAIT_RESUME_ALL_TASKS                  , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(476, RX_ADD_CLEANUP_HOOK                       , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(477, RX_SYS_SET_TIMESLICE_PARAMETERS           , rX_SysSetTimeSliceParameters              )
RX_JUMP_TABLE(478, RX_SYS_GET_TIMESLICE_PARAMETERS           , rX_SysGetTimeSliceParameters              )
RX_JUMP_TABLE(479, RX_CHECK_BARRIER                          , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(480, RX_BAS_MEM_CPY_FAST                       , rX_BasMemCpyFast                          )
RX_JUMP_TABLE(481, RX_DEV_GET_BOOTBLOCK                      , rX_DevGetBootblock                        )
RX_JUMP_TABLE(482, RX_DEV_SET_START_CODE                     , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(483, RX_DEV_SET_START_FAULT                    , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(484, RX_DIA_GET_TASK_STATUS_SENTINEL           , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(485, RX_DIA_CREATE_INFORMATION_FIELD_WITH_STRU , rX_DiaCreateInformationFieldWithStructInfo)
RX_JUMP_TABLE(486, RX_FLT_GET_TRACE_SENTINEL                 , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(487, RX_FLT_SET_FATAL_VECTOR                   , rX_FltSetFatalVector                      )
RX_JUMP_TABLE(488, RX_FLT_GET_FATAL_VECTOR                   , rX_FltGetFatalVector                      )
RX_JUMP_TABLE(489, RX_MEM_CHECK_MEMORY                       , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(490, RX_MEM_CHECK_IO_MEMORY                    , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(491, RX_MEM_CREATE_MEMORY_BANK_EXT             , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(492, RX_MEM_IDENTIFY_MEMORY_BANK               , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(493, RX_MEM_ALLOCATE_IO_MEMORY                 , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(494, RX_MEM_ALLOCATE_MEMORY_FROM_BANK          , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(495, RX_MEM_ALLOCATE_IO_MEMORY_FROM_BANK       , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(496, RX_MEM_FREE_IO_MEMORY                     , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(497, RX_CHECK_MUTEX                            , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(498, RX_GET_FROM_MULTIPLE                      , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(499, RX_PEEK_FROM_MULTIPLE                     , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(500, RX_GET_TOKEN_PRIO_FROM_MULTIPLE           , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(501, RX_PEEK_TOKEN_PRIO_FROM_MULTIPLE          , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(502, RX_SET_MULTIPLE                           , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(503, RX_CLR_MULTIPLE                           , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(504, RX_MULTIPLE                               , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(505, RX_PEEK_MULTIPLE                          , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(506, RX_IS_MULTIPLE                            , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(507, RX_FAST_LOCK                              , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(508, RX_FAST_UNLOCK                            , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(509, HAL_CPU_FIQ_SET_VECTOR                    , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(510, RX_CHECK_SEMAPHORE                        , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(511, DRV_URT_ENABLE_RECEIVER                   , Drv_UrtEnableReceiver                     )
RX_JUMP_TABLE(512, DRV_URT_ENABLE_TRANSMITTER                , Drv_UrtEnableTransmitter                  )
RX_JUMP_TABLE(513, DRV_URT_SEND                              , Drv_UrtSend                               )
RX_JUMP_TABLE(514, DRV_URT_RECV                              , Drv_UrtRecv                               )
RX_JUMP_TABLE(515, RX_MEM_GET_EXCHANGED_BUFFER_WAIT          , rX_MemGetExchangedBufferWait              )
RX_JUMP_TABLE(516, RX_MEM_ENABLE_TRIPLE_CALLBACK             , rX_MemEnableTripleCallback                )
RX_JUMP_TABLE(517, RX_MEM_DISABLE_TRIPLE_CALLBACK            , rX_MemDisableTripleCallback               )
RX_JUMP_TABLE(518, RX_QUE_SET_LOAD_CALLBACK                  , rX_QueSetLoadCallback                     )
RX_JUMP_TABLE(519, DRV_HIF_CHANGE_HOST_HANDSHAKE_BIT         , Drv_HifChangeHostHandshkBit               )
RX_JUMP_TABLE(520, RX_FLT_SET_DRIVER_FAULT_VECTOR            , rX_FltSetDriverFaultVector                )
RX_JUMP_TABLE(521, RX_FLT_GET_DRIVER_FAULT_VECTOR            , rX_FltGetDriverFaultVector                )
RX_JUMP_TABLE(522, RX_FLT_DRIVER_FAULT                       , rX_FltDriverFault                         )
RX_JUMP_TABLE(523, DRV_PFL_PROGRAM_FLASH                     , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(524, DRV_PFL_INITIALIZE_FLASH                  , Drv_PflInitializeFlash                    )
RX_JUMP_TABLE(525, DRV_SEC_GET_HARDWARE_CONFIG               , Drv_SecGetHardwareConfig                  )
RX_JUMP_TABLE(526, DRV_SEC_GET_PCI_CONFIG                    , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(527, DRV_SEC_SET_HARDWARE_CONFIG               , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(528, DRV_SEC_SET_PCI_CONFIG                    , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(529, DRV_HIF_ENABLE_CHANNEL_WATCHDOG           , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(530, DRV_HIF_DISABLE_CHANNEL_WATCHDOG          , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(531, DRV_HIF_SET_CHANNEL_WATCHDOG_TIME         , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(532, DRV_HIF_GET_CHANNEL_WATCHDOG_TIME         , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(533, DRV_HIF_CHANGE_COS                        , Drv_HifChangeCOS                          )
RX_JUMP_TABLE(534, DRV_HIF_ENABLE_APP_COS                    , Drv_HifEnableAppCOS                       )
RX_JUMP_TABLE(535, DRV_HIF_DISABLE_APP_COS                   , Drv_HifDisableAppCOS                      )
RX_JUMP_TABLE(536, DRV_HIF_GET_APP_COS                       , Drv_HifGetAppCOS                          )
RX_JUMP_TABLE(537, DRV_HIF_RESET_CHANNEL_WATCHDOG            , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(538, DRV_EDD_REGISTER_RXERR                    , Drv_EddRegisterRxError                    )
RX_JUMP_TABLE(539, DRV_EDD_UNREGISTER_RXERR                  , Drv_EddUnregisterRxError                  )
RX_JUMP_TABLE(540, DRV_EDD_REGISTER_COLL_CBK                 , Drv_EddRegisterColCbk                     )
RX_JUMP_TABLE(541, DRV_EDD_UNREGISTER_COLL_CBK               , Drv_EddUnregisterColCbk                   )
RX_JUMP_TABLE(542, DRV_PFL_GET_FLASH_GEOMETRY                , Drv_PflGetFlashGeometry                   )
RX_JUMP_TABLE(543, RX_STRUPR                                 , strupr                                    )
RX_JUMP_TABLE(544, DRV_HIF_ENABLE_INIT_CALLBACK              , Drv_HifEnableInitCallback                 )
RX_JUMP_TABLE(545, DRV_HIF_ENABLE_LOCK_CONFIG_CALLBACK       , Drv_HifEnableLockConfigCallback           )
RX_JUMP_TABLE(546, RX_MEMSET                                 , memset                                    )
RX_JUMP_TABLE(547, DRV_HIF_DISABLE_BIT_FUNCTION              , Drv_HifDisableBitFunction                 )
RX_JUMP_TABLE(548, MID_LED_GET_STATE                         , Mid_LedGetState                           )
RX_JUMP_TABLE(549, MID_DBM_GET_DATABASE_PROPERTY             , Mid_DbmGetDatabaseProperty                )
RX_JUMP_TABLE(550, DRV_XC_RESET_XC                           , Drv_XcResetXc                             )
RX_JUMP_TABLE(551, MID_LED_CREATE_LED                        , Mid_LedCreateLed                          )
RX_JUMP_TABLE(552, DRV_HIF_DISABLE_APP_READY_CALLBACK        , Drv_HifDisableAppReadyCallback            )
RX_JUMP_TABLE(553, DRV_HIF_SET_COM_COS_CONFIG_NEW            , Drv_HifSetComCosConfigNew                 )
RX_JUMP_TABLE(554, DRV_XC_TRIGGER_WATCHDOG                   , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(555, RX_MEMCPY                                 , memcpy                                    )
RX_JUMP_TABLE(556, DRV_XC_DISABLE_WATCHDOG                   , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(557, DRV_HIF_DISABLE_INITCALLBACK              , Drv_HifDisableInitCallback                )
RX_JUMP_TABLE(558, MID_LED_SET_SCRIPT                        , Mid_LedSetScript                          )
RX_JUMP_TABLE(559, DRV_HIF_SET_COM_COS_RESTART_REQUIRED      , Drv_HifSetComCosRestartRequired           )
RX_JUMP_TABLE(560, MID_LED_SET_STATE                         , Mid_LedSetState                           )
RX_JUMP_TABLE(561, RX_QUE_IDENTIFY_MTU                       , rX_QueIdentifyMTU                         )
RX_JUMP_TABLE(562, DRV_HIF_DISABLE_LOCK_CONFIG_CALLBACK      , Drv_HifDisableLockConfigCallback          )
RX_JUMP_TABLE(563, DRV_EDD_SEND_TIMESTAMP                    , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(564, DRV_HIF_SET_CHANNEL_INFO_DATA             , Drv_HifSetChannelInfoData                 )
RX_JUMP_TABLE(565, RX_MEMCMP                                 , memcmp                                    )
RX_JUMP_TABLE(566, DRV_HIF_SET_COM_COS_BUS_ON                , Drv_HifSetComCosBusOn                     )
RX_JUMP_TABLE(567, RX_MEM_EXCHANGE_GET_CURRENT_BUFFER        , rX_MemExchangeGetCurrentBuffer            )
RX_JUMP_TABLE(568, RX_STRLEN                                 , strlen                                    )
RX_JUMP_TABLE(569, DRV_FIF_READ_MULTIPLE_FROM_FIFO           , Drv_FifReadMultipleFromFifo               )
RX_JUMP_TABLE(570, MID_LED_RELEASE_LED                       , Mid_LedReleaseLed                         )
RX_JUMP_TABLE(571, RX_STRNCPY                                , strncpy                                   )
RX_JUMP_TABLE(572, DRV_SEC_GET_ZONE1_DATA                    , Drv_SecGetZone1Data                       )
RX_JUMP_TABLE(573, DRV_HIF_ENABLE_APP_READY_CALLBACK         , Drv_HifEnableAppReadyCallback             )
RX_JUMP_TABLE(574, DRV_SFL_PROGRAM_FLASH                     , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(575, RX_STRCPY                                 , strcpy                                    )
RX_JUMP_TABLE(576, DRV_HIF_COMMIT_CHANNEL_MAPPING            , Drv_HifCommitChannelMapping               )
RX_JUMP_TABLE(577, DRV_EDD_CONVERT_TIMESTAMP_TO_TIME         , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(578, DRV_SFL_GET_FLASH_SECTOR_SIZE             , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(579, DRV_FIF_WRITE_MULTIPLE_TO_FIFO            , Drv_FifWriteMultipleToFifo                )
RX_JUMP_TABLE(580, RX_DEV_GET_CHIP_TYPE                      , rX_DevGetChiptype                         )
RX_JUMP_TABLE(581, DRV_HIF_SET_COM_COS_READY                 , Drv_HifSetComCosReady                     )
RX_JUMP_TABLE(582, DRV_EDD_REGISTER_FOR_EDD_EVENTS           , Drv_EddRegisterForEddEvents               )
RX_JUMP_TABLE(583, DRV_XC_GET_IO_MEMORY                      , Drv_XcGetIOMemory                         )
RX_JUMP_TABLE(584, RX_STRCMP                                 , strcmp                                    )
RX_JUMP_TABLE(585, RX_MEM_GET_FREE_MEMORY                    , rX_MemGetFreeMemory                       )
RX_JUMP_TABLE(586, DRV_EDD_UNREGISTER_FOR_EDD_EVENTS         , Drv_EddUnregisterForEddEvents             )
RX_JUMP_TABLE(587, DRV_SEC_CHECK_LICENSE                     , Drv_SecCheckLicense                       )
RX_JUMP_TABLE(588, DRV_SEC_GET_IDENTIFICATION_DATA           , Drv_SecGetIdentificationData              )
RX_JUMP_TABLE(589, DRV_FIF_INITIALIZE_FIFO_CHANNEL           , Drv_FifInitializeFifochannel              )
RX_JUMP_TABLE(590, MID_DBM_WRITE_FILE                        , Mid_DbmWriteFile                          )
RX_JUMP_TABLE(591, MID_DBM_GET_LL_HANDLE                     , Mid_DbmGetLLHandle                        )
RX_JUMP_TABLE(592, DRV_HIF_SET_COM_COS_CONFIG_LOCKED         , Drv_HifSetComCosConfigLocked              )
RX_JUMP_TABLE(593, DRV_SFL_ERASE_FLASH_SECTOR                , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(594, DRV_HIF_DISABLE_BUS_ON_CALLBACK           , Drv_HifDisableBusOnCallback               )
RX_JUMP_TABLE(595, DRV_HIF_SET_COM_COS_RUN                   , Drv_HifSetComCosRun                       )
RX_JUMP_TABLE(596, DRV_SFL_GET_FLASH_INFO                    , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(597, RX_SIG_DELETE_SIGNAL                      , rX_SigDeleteSignal                        )
RX_JUMP_TABLE(598, RX_STRNCMP                                , strncmp                                   )
RX_JUMP_TABLE(599, MID_FAT_GET_DISK_FREE                     , Mid_FatGetDiskFree                        )
RX_JUMP_TABLE(600, DRV_HIF_ENABLE_BUS_ON_CALLBACK            , Drv_HifEnableBusOnCallback                )
RX_JUMP_TABLE(601, DRV_SEC_GET_OS_SETTINGS                   , Drv_SecGetOsSettings                      )
RX_JUMP_TABLE(602, DRV_SFL_GET_NUM_FLASH_SECTORS             , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(603, TLR_TIMER_INTERRUPT_REGISTER              , TlrTimerInterruptRegister                 )
RX_JUMP_TABLE(604, TLR_TIMER_INTERRUPT_UNREGISTER            , TlrTimerInterruptUnregister               )
RX_JUMP_TABLE(605, TLR_TIMER_INTERRUPT_RESET                 , TlrTimerInterruptReset                    )
RX_JUMP_TABLE(606, TLR_TIMER_INTERRUPT_WAIT                  , TlrTimerInterruptWait                     )
RX_JUMP_TABLE(607, TLR_TIMER_APPLICATION_CREATE              , TlrTimerApplicationCreate                 )
RX_JUMP_TABLE(608, TLR_TIMER_APPLICATION_DELETE              , TlrTimerApplicationDelete                 )
RX_JUMP_TABLE(609, TLR_TIMER_APPLICATION_START               , TlrTimerApplicationStart                  )
RX_JUMP_TABLE(610, TLR_TIMER_APPLICATION_STOP                , TlrTimerApplicationStop                   )
RX_JUMP_TABLE(611, TLR_TIMER_APPLICATION_GET_REMAINING_TIME  , TlrTimerApplicationGetRemainingTime       )
RX_JUMP_TABLE(612, TLR_TIMER_APPLICATION_GET_ELAPSED_TIME    , TlrTimerApplicationGetElapsedTime         )
RX_JUMP_TABLE(613, TLR_TIMER_APPLICATION_RETRIGGER           , TlrTimerApplicationRetrigger              )
RX_JUMP_TABLE(614, TLR_TIMER_APPLICATION_RELOAD              , TlrTimerApplicationReload                 )
RX_JUMP_TABLE(615, TLR_TIMER_APPLICATION_INIT_PACKET         , TlrTimerApplicationInitPacket             )
RX_JUMP_TABLE(616, TLR_TIMER_APPLICATION_INIT_RELOAD         , TlrTimerApplicationInitReload             )
RX_JUMP_TABLE(617, TLR_TIMER_PACKET_RETRY                    , TlrTimerPacketRetry                       )
RX_JUMP_TABLE(618, TLR_OS_TIME_TO_TICK                       , TLR_OS_TimeToTick                         )
RX_JUMP_TABLE(619, TLR_OS_MICROTIME_TO_TICK                  , TLR_OS_MicroTimeToTick                    )
RX_JUMP_TABLE(620, TLR_OS_TICK_TO_TIME                       , TLR_OS_TickToTime                         )
RX_JUMP_TABLE(621, TLR_OS_HARDTIMER_CREATE                   , TLR_OS_HardTimerCreate                    )
RX_JUMP_TABLE(622, TLR_OS_HARDTIMER_DELETE                   , TLR_OS_HardTimerDelete                    )
RX_JUMP_TABLE(623, TLR_OS_SEMAPHORE_CREATE                   , TLR_OS_SemaphoreCreate                    )
RX_JUMP_TABLE(624, TLR_OS_SEMAPHORE_DELETE                   , TLR_OS_SemaphoreDelete                    )
RX_JUMP_TABLE(625, TLR_OS_MUTEX_CREATE                       , TLR_OS_MutexCreate                        )
RX_JUMP_TABLE(626, TLR_OS_MUTEX_DELETE                       , TLR_OS_MutexDelete                        )
RX_JUMP_TABLE(627, TLR_OS_TRIPLE_BUFFER_CREATE               , TLR_OS_TripleBufferCreate                 )
RX_JUMP_TABLE(628, TLR_OS_TRIPLE_BUFFER_DELETE               , TLR_OS_TripleBufferDelete                 )
RX_JUMP_TABLE(629, TLR_OS_TASK_SET_LEAVE_FUNCTION            , TLR_OS_TaskSetLeaveFunction               )
RX_JUMP_TABLE(630, TLR_OS_MSG_QUEUE_CREATE                   , TLR_OS_MsgQueueCreate                     )
RX_JUMP_TABLE(631, TLR_OS_MSG_QUEUE_DELETE                   , TLR_OS_MsgQueueDelete                     )
RX_JUMP_TABLE(632, TLR_OS_HOOK_DELETE                        , TLR_OS_HookDelete                         )
RX_JUMP_TABLE(633, TLR_ROUTER_PACKET_RECEIVED                , TlrRouter_PacketReceived                  )
RX_JUMP_TABLE(634, TLR_ROUTER_PACKET_RECEIVED_POST           , TlrRouter_PacketReceivedPost              )
RX_JUMP_TABLE(635, TLR_ROUTER_PACKET_RECEIVED_POST_TOO_LONG  , TlrRouter_PacketReceivedPostTooLong       )
RX_JUMP_TABLE(636, TLR_ROUTER_PACKET_RECEIVED_POST_WITH_ERRO , TlrRouter_PacketReceivedPostWithError     )
RX_JUMP_TABLE(637, TLR_ROUTER_PACKET_SENDABLE                , TlrRouter_PacketSendable                  )
RX_JUMP_TABLE(638, TLR_WATCHDOG_ACTIVATE                     , Tlr_Watchdog_Activate                     )
RX_JUMP_TABLE(639, TLR_WATCHDOG_CALLBACK                     , Tlr_Watchdog_Callback                     )
RX_JUMP_TABLE(640, TLR_WATCHDOG_DEINITIALIZE                 , Tlr_Watchdog_Deinitialize                 )
RX_JUMP_TABLE(641, TLR_WATCHDOG_HANDLE_WATCHDOG              , Tlr_Watchdog_HandleWatchdog               )
RX_JUMP_TABLE(642, TLR_WATCHDOG_INITIALIZE                   , Tlr_Watchdog_Initialize                   )
RX_JUMP_TABLE(643, TLR_WATCHDOG_SEND_TIMEOUT                 , Tlr_Watchdog_SendTimeoutPacket            )
RX_JUMP_TABLE(644, DRV_PHY_GET_PHY_SIZE                      , Drv_PhyGetPhySize                         )
RX_JUMP_TABLE(645, RX_START_NEXT_TASK                        , rXStartNextTask                           )
RX_JUMP_TABLE(646, RX_CHECK_IF_START_NEXT_TASK_IS_ACTIVE     , rXCheckIfStartNextTaskIsActive            )
RX_JUMP_TABLE(647, HAL_CPU_TRANSLATE_ADDRESS                 , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(648, MID_DBMDYNDATABASEOPEN                    , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(649, MID_DBMDYNDATABASECLOSE                   , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(650, MID_DBMDYNGETDATABASEPROPERTY             , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(651, MID_DBMDYNDATABASEWRITE                   , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(652, MID_DBMDYNTABLEOPEN                       , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(653, MID_DBMDYNTABLECLOSE                      , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(654, MID_DBMDYNGETTABLEPROPERTY                , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(655, MID_DBMDYNTABLEOPENTRANSACTION            , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(656, MID_DBMDYNTABLECLOSETRANSACTION           , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(657, MID_DBMDYNTABLECANCELTRANSACTION          , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(658, MID_DBMDYNRECORDOPEN                      , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(659, MID_DBMDYNRECORDCLOSE                     , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(660, MID_DBMDYNRECORDREAD                      , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(661, MID_DBMDYNRECORDNEW                       , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(662, MID_DBMDYNRECORDWRITE                     , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(663, MID_DBMDYNRECORDDELETE                    , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(664, MID_DBMDYNGETRECORDPROPERTY               , UNSUPPORTED_FUNCTION                      )
RX_JUMP_TABLE(665, DRV_HIF_ENABLE_DMA_CALLBACK               , Drv_HifEnableDMACallback                  )
RX_JUMP_TABLE(666, DRV_HIF_DISABLE_DMA_CALLBACK              , Drv_HifDisableDMACallback                 )
RX_JUMP_TABLE(667, DRV_HIF_SET_COM_COS_DMA                   , Drv_HifSetComCosDMA                       )
RX_JUMP_TABLE(668, DRV_HIF_SETUP_DMA                         , Drv_HifSetupDMA                           )
RX_JUMP_TABLE(669, DRV_HIF_ENABLE_DMA                        , Drv_HifEnableDMA                          )
RX_JUMP_TABLE(670, DRV_URT_GETLASTERROR                      , Drv_UrtGetLastError                       )
RX_JUMP_TABLE(671, TLR_EXT_DEV_STAT_ENTITY_CREATE            , TLR_ExtDevStatEntityCreate                )
RX_JUMP_TABLE(672, TLR_EXT_DEV_STAT_INITIALIZE               , TLR_ExtDevStatInitialize                  )
RX_JUMP_TABLE(673, TLR_EXT_DEV_STAT_BLOCK_RESET              , TLR_ExtDevStatBlockReset                  )
RX_JUMP_TABLE(674, MID_FAT_FLUSH_FILE                        , Mid_FatFlushFile                          )
RX_JUMP_TABLE(675, DRV_SYSTIME_SET_TIME                      , Drv_SysTimeSetTime                        )
RX_JUMP_TABLE(676, DRV_SYSTIME_GET_TIME                      , Drv_SysTimeGetTime                        )
RX_JUMP_TABLE(677, DRV_SYSTIME_SET_SYSTIME_BORDER            , Drv_SysTimeSetSysTimeBorder               )
RX_JUMP_TABLE(678, DRV_SYSTIME_GET_SYSTIME_BORDER            , Drv_SysTimeGetSysTimeBorder               )
RX_JUMP_TABLE(679, DRV_SYSTIME_SET_SYSTIME_COUNT_VALUE       , Drv_SysTimeSetSysTimeCountValue           )
RX_JUMP_TABLE(680, DRV_SYSTIME_GET_SYSTIME_COUNT_VALUE       , Drv_SysTimeGetSysTimeCountValue           )
RX_JUMP_TABLE(681, DRV_SYSTIME_ADD_TIME                      , Drv_SysTimeAddTime                        )
RX_JUMP_TABLE(682, DRV_SYSTIME_COMPARE_SYSTIME               , Drv_SysTimeCompareSystime                 )
RX_JUMP_TABLE(683, DRV_SYSTIME_COMPARE_TIMESTAMPS            , Drv_SysTimeCompareTimestamps              )
RX_JUMP_TABLE(684, DRV_SYSTIME_GET_TIMESTAMP_DIFFERENCE      , Drv_SysTimeGetTimestampDifference         )
RX_JUMP_TABLE(685, DRV_HIFSYNC_CONFIGURE_SYNC_HANDSHAKE      , Drv_HifSyncConfigureSyncHandshake         )
RX_JUMP_TABLE(686, DRV_HIFSYNC_ENABLE_SYNC_INTERRUPT         , Drv_HifSyncEnableSyncInterrupt            )
RX_JUMP_TABLE(687, DRV_HIFSYNC_DISABLE_SYNC_INTERRUPT        , Drv_HifSyncDisableSyncInterrupt           )
RX_JUMP_TABLE(688, DRV_HIFSYNC_TOGGLE_SYNC_HANDSHAKE         , Drv_HifSyncToggleSyncHandshake            )
RX_JUMP_TABLE(689, TLR_TIMER_APPLICATION_GET_PACKET          , TlrTimerApplicationGetPacket              )
RX_JUMP_TABLE(690, LIBC_REGISTER_STDIN_FILEHOOK              , Libc_RegisterStdInFileHook                )
RX_JUMP_TABLE(691, LIBC_REGISTER_STDOUT_FILEHOOK             , Libc_RegisterStdOutFileHook               )
RX_JUMP_TABLE(692, DRV_I2C_IDENTIFY_I2C                      , Drv_I2cIdentifyBus                        )
RX_JUMP_TABLE(693, DRV_I2C_LOCK_I2C                          , Drv_I2cLockBus                            )
RX_JUMP_TABLE(694, DRV_I2C_UNLOCK_I2C                        , Drv_I2cUnlockBus                          )
RX_JUMP_TABLE(695, DRV_I2C_SEND_I2C                          , Drv_I2cSend                               )
RX_JUMP_TABLE(696, DRV_I2C_RECEIVE_I2C                       , Drv_I2cReceive                            )
RX_JUMP_TABLE(697, MID_RTC_GET_TIME                          , Mid_RtcGetTime                            )
RX_JUMP_TABLE(698, MID_RTC_SET_TIME                          , Mid_RtcSetTime                            )
RX_JUMP_TABLE(699, MID_RTC_GET_INFO                          , Mid_RtcGetInfo                            )
RX_JUMP_TABLE(700, MID_RTC_LOCAL_TIME                        , Mid_RtcLocalTime                          )
RX_JUMP_TABLE(701, MID_RTC_MK_TIME                           , Mid_RtcMkTime                             )
RX_JUMP_TABLE(702, MID_RTC_REGISTER_CALLBACK                 , Mid_RtcRegisterCallback                   )
RX_JUMP_TABLE(703, RX_SYS_CREATE_TASKEX                      , rX_SysCreateTaskEx                        )
RX_JUMP_TABLE(704, RX_SYS_GET_TASKRUNTIME                    , rX_SysGetTaskRuntime                      )
RX_JUMP_TABLE(705, RX_DDP_GETBASE_DEVICEDATA                 , rX_DdpGetBaseDeviceData                   )
RX_JUMP_TABLE(706, RX_DDP_GETEXT_DEVICEDATA                  , rX_DdpGetExtendedDeviceData               )
RX_JUMP_TABLE(707, RX_DDP_SETBASE_DEVICEDATA                 , rX_DdpSetBaseDeviceData                   )
RX_JUMP_TABLE(708, RX_DDP_SETEXT_DEVICEDATA                  , rX_DdpSetExtendedDeviceData               )
RX_JUMP_TABLE(709, DRV_TIM_GET_CONFIG                        , Drv_TimGetConfig                          )
RX_JUMP_TABLE(710, DRV_TIM_SET_PERIOD                        , Drv_TimSetPeriod                          )
RX_JUMP_TABLE(711, DRV_SPI_GET_CONFIG                        , Drv_SpiGetConfig                          )
RX_JUMP_TABLE(712, DRV_SPI_SET_BUSIRQHANDLER                 , DrvSpiSetBusIrqHandler                    )
RX_JUMP_TABLE(713, DRV_SPI_GET_BUSIRQHANDLER                 , DrvSpiGetBusIrqHandler                    )
RX_JUMP_TABLE(714, DRV_IO_CREATE                             , Drv_IOCreate                              )
RX_JUMP_TABLE(715, DRV_IO_IDENTIFY                           , Drv_IOIdentify                            )
RX_JUMP_TABLE(716, DRV_IO_SETDIR                             , Drv_IOSetDirection                        )
RX_JUMP_TABLE(717, DRV_IO_GETDIR                             , Drv_IOGetDirection                        )
RX_JUMP_TABLE(718, DRV_IO_SETLEVEL                           , Drv_IOSetLevel                            )
RX_JUMP_TABLE(719, DRV_IO_GETLEVEL                           , Drv_IOGetLevel                            )
RX_JUMP_TABLE(720, DRV_IO_SETBANK                            , Drv_IOSetBank                             )
RX_JUMP_TABLE(721, DRV_IO_GETBANK                            , Drv_IOGetBank                             )
RX_JUMP_TABLE(722, DRV_IO_GETINFO                            , Drv_IOGetInfo                             )
RX_JUMP_TABLE(723, DRV_IO_CTRL                               , Drv_IOCtrl                                )
RX_JUMP_TABLE(724, MD5_INIT                                  , md5_init                                  )
RX_JUMP_TABLE(725, MD5_APPEND                                , md5_append                                )
RX_JUMP_TABLE(726, MD5_FINISH                                , md5_finish                                )
RX_JUMP_TABLE(727, LOAD_XC                                   , LoadXc                                    )
RX_JUMP_TABLE(728, RESET_XC                                  , ResetXc                                   )
RX_JUMP_TABLE(729, DISABLE_XC                                , DisableXc                                 )
RX_JUMP_TABLE(730, ENABLE_XC                                 , EnableXc                                  )
RX_JUMP_TABLE(731, GET_ADDRESS_XC                            , GetAddressXc                              )
RX_JUMP_TABLE(732, DDP2_INIT                                 , Ddp_Init                                  )
RX_JUMP_TABLE(733, DDP2_DEINIT                               , Ddp_Deinit                                )
RX_JUMP_TABLE(734, DDP2_GETDATA                              , Ddp_GetData                               )
RX_JUMP_TABLE(735, DDP2_SETDATA                              , Ddp_SetData                               )
RX_JUMP_TABLE(736, DDP2_SUBSCRIBE                            , Ddp_Subscribe                             )
RX_JUMP_TABLE(737, DDP2_UNSUBSCRIBE                          , Ddp_Unsubscribe                           )
RX_JUMP_TABLE_END(RX_FUNCTIONS, RX_FUNCTION_LAST)
#endif /* EXCLUDE_RX_FUNCTIONS */

#ifndef EXCLUDE_LIBC_FUNCTIONS
RX_JUMP_TABLE_BEGIN(LIBC_FUNCTIONS)
RX_JUMP_TABLE(  0, LIBC_RESERVED0    , UNSUPPORTED_FUNCTION )
RX_JUMP_TABLE(  1, LIBC_RESERVED1    , UNSUPPORTED_FUNCTION )
RX_JUMP_TABLE(  2, LIBC_ABORT        , UNSUPPORTED_FUNCTION )
RX_JUMP_TABLE(  3, LIBC_ABS          , abs                  )
RX_JUMP_TABLE(  4, LIBC_ASCTIME      , asctime              )
RX_JUMP_TABLE(  5, LIBC___ASSERT     , UNSUPPORTED_FUNCTION )
RX_JUMP_TABLE(  6, LIBC_ATOF         , atof                 )
RX_JUMP_TABLE(  7, LIBC_ATOFF        , atoff                )
RX_JUMP_TABLE(  8, LIBC_ATOI         , atoi                 )
RX_JUMP_TABLE(  9, LIBC_ATOL         , atol                 )
RX_JUMP_TABLE( 10, LIBC_ATOLL        , atoll                )
RX_JUMP_TABLE( 11, LIBC_BCMP         , bcmp                 )
RX_JUMP_TABLE( 12, LIBC_BCOPY        , bcopy                )
RX_JUMP_TABLE( 13, LIBC_BSEARCH      , bsearch              )
RX_JUMP_TABLE( 14, LIBC_BZERO        , bzero                )
RX_JUMP_TABLE( 15, LIBC_CALLOC       , calloc               )
RX_JUMP_TABLE( 16, LIBC_CFREE        , cfree                )
RX_JUMP_TABLE( 17, LIBC_CLOCK        , UNSUPPORTED_FUNCTION )
RX_JUMP_TABLE( 18, LIBC_CTIME        , ctime                )
RX_JUMP_TABLE( 19, LIBC_DIFFTIME     , difftime             )
RX_JUMP_TABLE( 20, LIBC_DIV          , div                  )
RX_JUMP_TABLE( 21, LIBC_GMTIME       , gmtime               )
RX_JUMP_TABLE( 22, LIBC_INDEX        , index                )
RX_JUMP_TABLE( 23, LIBC_ISALNUM      , isalnum              )
RX_JUMP_TABLE( 24, LIBC_ISALPHA      , isalpha              )
RX_JUMP_TABLE( 25, LIBC_ISASCII      , isascii              )
RX_JUMP_TABLE( 26, LIBC_ISBLANK      , isblank              )
RX_JUMP_TABLE( 27, LIBC_ISCNTRL      , iscntrl              )
RX_JUMP_TABLE( 28, LIBC_ISDIGIT      , isdigit              )
RX_JUMP_TABLE( 29, LIBC_ISLOWER      , islower              )
RX_JUMP_TABLE( 30, LIBC_ISGRAPH      , isgraph              )
RX_JUMP_TABLE( 31, LIBC_ISPRINT      , isprint              )
RX_JUMP_TABLE( 32, LIBC_ISPUNCT      , ispunct              )
RX_JUMP_TABLE( 33, LIBC_ISSPACE      , isspace              )
RX_JUMP_TABLE( 34, LIBC_ISUPPER      , isupper              )
RX_JUMP_TABLE( 35, LIBC_ISXDIGIT     , isxdigit             )
RX_JUMP_TABLE( 36, LIBC_LABS         , labs                 )
RX_JUMP_TABLE( 37, LIBC_LOCALTIME    , localtime            )
RX_JUMP_TABLE( 38, LIBC_LDIV         , ldiv                 )
RX_JUMP_TABLE( 39, LIBC_LLABS        , llabs                )
RX_JUMP_TABLE( 40, LIBC_LLDIV        , lldiv                )
RX_JUMP_TABLE( 41, LIBC_MEMALIGN     , memalign             )
RX_JUMP_TABLE( 42, LIBC_FREE         , free                 )
RX_JUMP_TABLE( 43, LIBC_MALLOC       , malloc               )
RX_JUMP_TABLE( 44, LIBC_MEMCCPY      , memccpy              )
RX_JUMP_TABLE( 45, LIBC_MEMCHR       , memchr               )
RX_JUMP_TABLE( 46, LIBC_MEMCMP       , memcmp               )
RX_JUMP_TABLE( 47, LIBC_MEMCPY       , memcpy               )
RX_JUMP_TABLE( 48, LIBC_MEMMOVE      , memmove              )
RX_JUMP_TABLE( 49, LIBC_MEMPCPY      , mempcpy              )
RX_JUMP_TABLE( 50, LIBC_MEMSET       , memset               )
RX_JUMP_TABLE( 51, LIBC_MKSTEMP      , UNSUPPORTED_FUNCTION )
RX_JUMP_TABLE( 52, LIBC_MKTEMP       , UNSUPPORTED_FUNCTION )
RX_JUMP_TABLE( 53, LIBC_MKTIME       , mktime               )
RX_JUMP_TABLE( 54, LIBC_MALLINFO     , mallinfo             )
RX_JUMP_TABLE( 55, LIBC_MALLOC_STATS , malloc_stats         )
RX_JUMP_TABLE( 56, LIBC_MALLOPT      , mallopt              )
RX_JUMP_TABLE( 57, LIBC_MSTATS       , mstats               )
RX_JUMP_TABLE( 58, LIBC_MALLOC_TRIM  , malloc_trim          )
RX_JUMP_TABLE( 59, LIBC_PRINTF       , printf               )
RX_JUMP_TABLE( 60, LIBC_PUTC         , putc                 )
RX_JUMP_TABLE( 61, LIBC_PUTCHAR      , putchar              )
RX_JUMP_TABLE( 62, LIBC_PUTS         , puts                 )
RX_JUMP_TABLE( 63, LIBC_QSORT        , qsort                )
RX_JUMP_TABLE( 64, LIBC_RAND         , rand                 )
RX_JUMP_TABLE( 65, LIBC_SRAND        , srand                )
RX_JUMP_TABLE( 66, LIBC_REALLOC      , realloc              )
RX_JUMP_TABLE( 67, LIBC_REWIND       , rewind               )
RX_JUMP_TABLE( 68, LIBC_RINDEX       , rindex               )
RX_JUMP_TABLE( 69, LIBC_COPYSIGN     , copysign             )
RX_JUMP_TABLE( 70, LIBC_FINITE       , finite               )
RX_JUMP_TABLE( 71, LIBC_FREXP        , frexp                )
RX_JUMP_TABLE( 72, LIBC_ISINF        , isinf                )
RX_JUMP_TABLE( 73, LIBC_ISNAN        , isnan                )
RX_JUMP_TABLE( 74, LIBC_LDEXP        , ldexp                )
RX_JUMP_TABLE( 75, LIBC_MODF         , modf                 )
RX_JUMP_TABLE( 76, LIBC_NAN          , nan                  )
RX_JUMP_TABLE( 77, LIBC_SCALBN       , scalbn               )
RX_JUMP_TABLE( 78, LIBC_SETBUF       , setbuf               )
RX_JUMP_TABLE( 79, LIBC_SETBUFFER    , setbuffer            )
RX_JUMP_TABLE( 80, LIBC_SETENV       , setenv               )
RX_JUMP_TABLE( 81, LIBC_UNSETENV     , unsetenv             )
RX_JUMP_TABLE( 82, LIBC_LONGJMP      , longjmp              )
RX_JUMP_TABLE( 83, LIBC_SETJMP       , setjmp               )
RX_JUMP_TABLE( 84, LIBC_SETLINEBUF   , setlinebuf           )
RX_JUMP_TABLE( 85, LIBC_SETVBUF      , setvbuf              )
RX_JUMP_TABLE( 86, LIBC_COPYSIGNF    , copysignf            )
RX_JUMP_TABLE( 87, LIBC_FINITEF      , finitef              )
RX_JUMP_TABLE( 88, LIBC_FREXPF       , frexpf               )
RX_JUMP_TABLE( 89, LIBC_ISINFF       , isinff               )
RX_JUMP_TABLE( 90, LIBC_ISNANF       , isnanf               )
RX_JUMP_TABLE( 91, LIBC_LDEXPF       , ldexpf               )
RX_JUMP_TABLE( 92, LIBC_MODFF        , modff                )
RX_JUMP_TABLE( 93, LIBC_NANF         , nanf                 )
RX_JUMP_TABLE( 94, LIBC_SCALBNF      , scalbnf              )
RX_JUMP_TABLE( 95, LIBC_SNPRINTF     , snprintf             )
RX_JUMP_TABLE( 96, LIBC_SPRINTF      , sprintf              )
RX_JUMP_TABLE( 97, LIBC_SSCANF       , sscanf               )
RX_JUMP_TABLE( 98, LIBC_STRCASECMP   , strcasecmp           )
RX_JUMP_TABLE( 99, LIBC_STRCAT       , strcat               )
RX_JUMP_TABLE(100, LIBC_STRCHR       , strchr               )
RX_JUMP_TABLE(101, LIBC_STRCMP       , strcmp               )
RX_JUMP_TABLE(102, LIBC_STRCOLL      , strcoll              )
RX_JUMP_TABLE(103, LIBC_STRCPY       , strcpy               )
RX_JUMP_TABLE(104, LIBC_STRCSPN      , strcspn              )
RX_JUMP_TABLE(105, LIBC_STRDUP       , strdup               )
RX_JUMP_TABLE(106, LIBC_STRFTIME     , strftime             )
RX_JUMP_TABLE(107, LIBC_STRLCAT      , strlcat              )
RX_JUMP_TABLE(108, LIBC_STRLCPY      , strlcpy              )
RX_JUMP_TABLE(109, LIBC_STRLEN       , strlen               )
RX_JUMP_TABLE(110, LIBC_STRLWR       , strlwr               )
RX_JUMP_TABLE(111, LIBC_STRNCASECMP  , strncasecmp          )
RX_JUMP_TABLE(112, LIBC_STRNCAT      , strncat              )
RX_JUMP_TABLE(113, LIBC_STRNCMP      , strncmp              )
RX_JUMP_TABLE(114, LIBC_STRNCPY      , strncpy              )
RX_JUMP_TABLE(115, LIBC_STRNDUP      , strndup              )
RX_JUMP_TABLE(116, LIBC_STRNLEN      , strnlen              )
RX_JUMP_TABLE(117, LIBC_STRPBRK      , strpbrk              )
RX_JUMP_TABLE(118, LIBC_STRPTIME     , strptime             )
RX_JUMP_TABLE(119, LIBC_STRRCHR      , strrchr              )
RX_JUMP_TABLE(120, LIBC_STRSEP       , strsep               )
RX_JUMP_TABLE(121, LIBC_STRSPN       , strspn               )
RX_JUMP_TABLE(122, LIBC_STRSTR       , strstr               )
RX_JUMP_TABLE(123, LIBC_STRTOD       , strtod               )
RX_JUMP_TABLE(124, LIBC_STRTOF       , strtof               )
RX_JUMP_TABLE(125, LIBC_STRTOK       , strtok               )
RX_JUMP_TABLE(126, LIBC_STRTOL       , strtol               )
RX_JUMP_TABLE(127, LIBC_STRTOLL      , strtoll              )
RX_JUMP_TABLE(128, LIBC_STRTOUL      , strtoul              )
RX_JUMP_TABLE(129, LIBC_STRTOULL     , strtoull             )
RX_JUMP_TABLE(130, LIBC_STRUPR       , strupr               )
RX_JUMP_TABLE(131, LIBC_STRXFRM      , strxfrm              )
RX_JUMP_TABLE(132, LIBC_SWAB         , swab                 )
RX_JUMP_TABLE(133, LIBC_TEMPNAM      , UNSUPPORTED_FUNCTION )
RX_JUMP_TABLE(134, LIBC_TMPNAM       , UNSUPPORTED_FUNCTION )
RX_JUMP_TABLE(135, LIBC_TOASCII      , toascii              )
RX_JUMP_TABLE(136, LIBC_TOLOWER      , tolower              )
RX_JUMP_TABLE(137, LIBC_TOUPPER      , toupper              )
RX_JUMP_TABLE(138, LIBC_UNGETC       , ungetc               )
RX_JUMP_TABLE(139, LIBC_VPRINTF      , vprintf              )
RX_JUMP_TABLE(140, LIBC_VSCANF       , vscanf               )
RX_JUMP_TABLE(141, LIBC_VSNPRINTF    , vsnprintf            )
RX_JUMP_TABLE(142, LIBC_VSPRINTF     , vsprintf             )
RX_JUMP_TABLE(143, LIBC_VSSCANF      , vsscanf              )
RX_JUMP_TABLE(144, LIBC_ULTOA        , ultoa                )
RX_JUMP_TABLE_END(LIBC_FUNCTIONS, LIBC_FUNCTION_LAST)
#endif /* EXCLUDE_LIBC_FUNCTIONS */

#endif
